/*
 * Decompiled with CFR 0.152.
 */
package de.FBEditor.utils;

import de.FBEditor.utils.Debug;
import de.FBEditor.utils.Utils;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class CalcChecksum {
    private static int type = 0;
    private static boolean file = false;
    private static CRC32 crc;
    private static String expected;
    private static String last;

    public CalcChecksum() {
        crc = new CRC32();
    }

    private void calchk(String line) {
        if (type == 0) {
            String filename = Utils.pMatch("\\*\\*\\*\\* CFGFILE:(.*?)$", line, 1);
            if (filename != null) {
                Debug.debug(line);
                file = true;
                type = 1;
            } else {
                filename = Utils.pMatch("\\*\\*\\*\\* BINFILE:(.*?)$", line, 1);
                if (filename != null) {
                    file = true;
                    Debug.debug(line);
                    type = 2;
                } else {
                    if (Utils.pMatch("\\*\\*\\*\\* (.+) CONFIGURATION EXPORT", line, 0) != null) {
                        file = false;
                        Debug.debug(line);
                        type = 3;
                        return;
                    }
                    if (Utils.pMatch("\\*\\*\\*\\* END OF EXPORT (.*?)", line, 0) != null) {
                        expected = line.substring(19, 27);
                        Debug.debug(line);
                    }
                }
            }
            if (file) {
                line = filename + '\u0000';
                this.updateCRC(line);
                file = false;
                return;
            }
        } else {
            if (type == 1) {
                if (line.indexOf("**** END OF FILE") == 0) {
                    type = 0;
                    if (last != null) {
                        this.updateCRC(last);
                    }
                    last = null;
                    return;
                }
                if (last != null) {
                    last = last.replace("\\\\", "\\");
                    last = last + '\n';
                    this.updateCRC(last);
                }
                last = line;
                return;
            }
            if (type == 2) {
                if (line.indexOf("**** END OF FILE") == 0) {
                    type = 0;
                    return;
                }
                String hex = line.trim().toLowerCase().replace("\n", "");
                String bin_line = "";
                for (int i = 0; i < hex.length(); i += 2) {
                    bin_line = bin_line + (char)Integer.parseInt(hex.substring(i, i + 2), 16);
                }
                this.updateCRC(bin_line);
                return;
            }
            if (type == 3) {
                if (line.indexOf("****") != -1) {
                    type = 0;
                    this.calchk(line);
                }
                if (Utils.pMatch("(\\S*?)=(\\S*?)", line, 0) != null) {
                    line = line.replaceFirst("=", "");
                    line = line + '\u0000';
                    this.updateCRC(line);
                    return;
                }
                return;
            }
        }
    }

    public long getChecksum(String text) {
        text = text.replace("\r", "");
        Pattern p = Pattern.compile("(.*?)\\n", 2);
        Matcher matcher = p.matcher(text);
        while (matcher.find()) {
            String temp = matcher.group(0);
            this.calchk(matcher.group(0).replace("\n", ""));
        }
        return crc.getValue();
    }

    public static boolean getchecksum() {
        String checksum = Long.toHexString(crc.getValue()).toUpperCase();
        if (checksum.length() < 8) {
            checksum = '0' + checksum;
        }
        if (!checksum.equals(expected)) {
            Debug.debug("CHECKSUM FIXED: " + checksum + "(old: " + expected + ")");
            return false;
        }
        Debug.debug("CHECKSUM OK: " + checksum);
        return true;
    }

    private void updateCRC(String line) {
        try {
            crc.update(line.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static String replaceChecksum(String text) {
        String newText = "";
        String checksum = Utils.pMatch("\\*\\*\\*\\* END OF EXPORT (.*?) \\*\\*\\*\\*", text, 1);
        if (checksum != null) {
            CalcChecksum exportsumme = new CalcChecksum();
            String newChecksum = Long.toHexString(exportsumme.getChecksum(text));
            newChecksum = newChecksum.toUpperCase();
            newText = !CalcChecksum.getchecksum() ? text.replace(checksum, newChecksum) : text;
        } else {
            newText = text;
        }
        return newText;
    }

    static {
        expected = "";
    }
}

