/*
 * Decompiled with CFR 0.152.
 */
package de.FBEditor.struct;

import de.FBEditor.struct.MyHighlightPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;

public class JTextPane2
extends JTextPane
implements KeyListener {
    private static final long serialVersionUID = 1L;
    boolean wrap = false;
    public static final int DOS_LINE_END = 0;
    public static final int MACOS_LINE_END = 1;
    public static final int UNIX_LINE_END = 2;
    private String myLineTerm = "\n";
    private String origLineTerm = "\n";
    int maxCharacters = 0;
    private boolean insertMode = true;

    public JTextPane2() {
    }

    public JTextPane2(boolean wrap) {
        this.wrap = wrap;
    }

    public JTextPane2(StyledDocument doc) {
        super(doc);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.wrap) {
            return super.getScrollableTracksViewportWidth();
        }
        return false;
    }

    @Override
    public void setSize(Dimension d) {
        if (!this.wrap && d.width < this.getParent().getSize().width) {
            d.width = this.getParent().getSize().width;
        }
        super.setSize(d);
    }

    void setLineWrap(boolean wrap) {
        this.setVisible(false);
        this.wrap = wrap;
        this.setVisible(true);
    }

    String getLineTermName() {
        if ("\r".equals(this.myLineTerm)) {
            return "Mac";
        }
        if ("\n".equals(this.myLineTerm)) {
            return "UNIX";
        }
        if ("\r\n".equals(this.myLineTerm)) {
            return "DOS";
        }
        return "UNIX";
    }

    void setLineTerm(int lineTermConst) {
        switch (lineTermConst) {
            case 2: {
                this.myLineTerm = "\n";
                break;
            }
            case 1: {
                this.myLineTerm = "\r";
                break;
            }
            case 0: {
                this.myLineTerm = "\r\n";
            }
        }
    }

    public void setLineTerm(String newLineTerm) {
        this.myLineTerm = newLineTerm;
    }

    public String getLineTerm() {
        return this.myLineTerm;
    }

    @Override
    public void keyTyped(KeyEvent keyevent) {
    }

    @Override
    public void keyPressed(KeyEvent keyevent) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        if (arg0.getKeyCode() == 155) {
            this.toggleInsertMode();
        }
    }

    public boolean isInsertMode() {
        return this.insertMode;
    }

    public void toggleInsertMode() {
        this.insertMode = !this.insertMode;
    }

    public void setInsertMode(boolean insertMode) {
        this.insertMode = insertMode;
    }

    public static void findText(JTextPane2 pane, String s) {
        JTextPane2.highlight(pane, s, 0);
    }

    public static void findAll(JTextPane2 pane, String s) {
        JTextPane2.highlight(pane, s, 1);
    }

    public static void replaceText(JTextPane2 pane, String s) {
        JTextPane2.replace(pane, s, 0);
    }

    public static void replaceAll(JTextPane2 pane, String s) {
        JTextPane2.replace(pane, s, 1);
    }

    public static void highlight(JTextComponent textComp, String pattern, int findAll) {
        MyHighlightPainter myHighlightPainter = new MyHighlightPainter(Color.yellow);
        JTextPane2.removeHighlights(textComp);
        if (pattern.length() > 0) {
            try {
                Highlighter hilite = textComp.getHighlighter();
                Document doc = textComp.getDocument();
                String text = doc.getText(0, doc.getLength());
                text = text.toUpperCase();
                pattern = pattern.toUpperCase();
                int pos = textComp.getCaretPosition();
                pos = text.indexOf(pattern, pos);
                if (pos != -1) {
                    if (findAll == 0) {
                        hilite.addHighlight(pos, pos + pattern.length(), myHighlightPainter);
                        textComp.setCaretPosition(pos + pattern.length());
                        textComp.setSelectionStart(pos);
                        textComp.setSelectionEnd(pos + pattern.length());
                    } else {
                        while ((pos = text.indexOf(pattern, pos)) >= 0) {
                            hilite.addHighlight(pos, pos + pattern.length(), myHighlightPainter);
                            pos += pattern.length();
                        }
                    }
                }
            }
            catch (BadLocationException badlocationexception) {
                // empty catch block
            }
        }
    }

    private static void replace(JTextComponent textComp, String pattern, int replaceAll) {
        JTextPane2.removeHighlights(textComp);
        Document doc = textComp.getDocument();
        String text = "";
        try {
            text = doc.getText(0, doc.getLength());
            int pos = textComp.getCaretPosition();
            if (textComp.getSelectedText() != null) {
                String replacement = pattern;
                pattern = textComp.getSelectedText();
                if (replaceAll == 0) {
                    textComp.replaceSelection(replacement);
                } else {
                    textComp.replaceSelection(replacement);
                    text = doc.getText(0, doc.getLength());
                    while ((pos = text.indexOf(pattern, pos)) >= 0) {
                        textComp.setSelectionStart(pos);
                        textComp.setSelectionEnd(pos + pattern.length());
                        textComp.replaceSelection(replacement);
                        pos += replacement.length();
                    }
                }
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    private static void removeHighlights(JTextComponent textComp) {
        MyHighlightPainter myHighlightPainter = new MyHighlightPainter(Color.yellow);
        Highlighter hilite = textComp.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        for (int i = 0; i < hilites.length; ++i) {
            if (!(hilites[i].getPainter() instanceof MyHighlightPainter)) continue;
            hilite.removeHighlight(hilites[i]);
        }
    }
}

