/*
 * Decompiled with CFR 0.152.
 */
package de.FBEditor;

import de.FBEditor.ActionListen;
import de.FBEditor.FBEdit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class CutAndPastePopup
extends JComponent
implements ClipboardOwner {
    private static final long serialVersionUID = 1L;
    private static JPopupMenu popupMenu;
    private Clipboard clipbd;
    private String selection;
    JMenuItem revert;
    JMenuItem cut;
    JMenuItem copy;
    JMenuItem insert;
    JMenuItem delete;
    JMenuItem markall;
    JTextComponent source;

    public CutAndPastePopup(ActionListen action) {
        popupMenu = new JPopupMenu();
        popupMenu.setLabel(FBEdit.getMessage("menu.edit"));
        this.cut = new JMenuItem(FBEdit.getMessage("menu.cut"));
        this.copy = new JMenuItem(FBEdit.getMessage("menu.copy"));
        this.insert = new JMenuItem(FBEdit.getMessage("menu.insert"));
        this.delete = new JMenuItem(FBEdit.getMessage("menu.delete"));
        this.markall = new JMenuItem(FBEdit.getMessage("menu.markall"));
        this.clipbd = this.getToolkit().getSystemClipboard();
        this.cut.setActionCommand("cut");
        this.copy.setActionCommand("copy");
        this.insert.setActionCommand("insert");
        this.delete.setActionCommand("delete");
        this.markall.setActionCommand("markall");
        this.cut.addActionListener(action);
        this.copy.addActionListener(action);
        this.insert.addActionListener(action);
        this.delete.addActionListener(action);
        this.markall.addActionListener(action);
        popupMenu.add(this.cut);
        popupMenu.add(this.copy);
        popupMenu.add(this.insert);
        popupMenu.add(this.delete);
        popupMenu.addSeparator();
        popupMenu.add(this.markall);
    }

    public void updateMenu() {
        if (this.source.getSelectedText() != null) {
            this.copy.setEnabled(true);
            this.cut.setEnabled(true);
            this.delete.setEnabled(true);
        } else {
            this.copy.setEnabled(false);
            this.cut.setEnabled(false);
            this.delete.setEnabled(false);
        }
        if (this.clipbd.getContents(this) != null) {
            this.insert.setEnabled(true);
        } else {
            this.insert.setEnabled(false);
        }
    }

    @Override
    public void lostOwnership(Clipboard c, Transferable t) {
        this.selection = null;
    }

    public void updateSource(JTextComponent source) {
        this.source = source;
    }

    public void cut() {
        this.selection = this.source.getSelectedText();
        StringSelection clipString = new StringSelection(this.selection);
        this.clipbd.setContents(clipString, clipString);
        this.source.replaceSelection("");
    }

    public void copy() {
        this.selection = this.source.getSelectedText();
        StringSelection clipString = new StringSelection(this.selection);
        this.clipbd.setContents(clipString, clipString);
    }

    public void markall() {
        this.source.setSelectionStart(0);
        this.source.setSelectionEnd(this.source.getDocument().getLength());
    }

    public void paste() {
        Transferable clipData = this.clipbd.getContents(this);
        try {
            String clipString = (String)clipData.getTransferData(DataFlavor.stringFlavor);
            this.source.replaceSelection(clipString);
        }
        catch (Exception ex) {
            System.out.println("not String flavor");
        }
    }

    public void delete() {
        this.selection = this.source.getSelectedText();
        this.source.replaceSelection("");
    }

    public JPopupMenu getPopupMenu() {
        return popupMenu;
    }
}

